//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;
using System.Reflection;
using System.Reflection.Emit;
using System.Security;
using System.Security.Permissions;

namespace ProfilingSamples
{
	public class JitMain 
	{
		private Type GenerateCode()
		{
			AppDomain currentDomain = AppDomain.CurrentDomain;

			// Utworzenie nowego podzespou w aktualnej AppDomain
			AssemblyName assemblyName = new AssemblyName();
			assemblyName.Name = "HelloAssembly";
			// Utworzenie AssemblyBuilder
			AssemblyBuilder assemblyBuilder = currentDomain.DefineDynamicAssembly(assemblyName, AssemblyBuilderAccess.Run);
			// Utworzenie ModuleBuilder
			ModuleBuilder moduleBuilder = assemblyBuilder.DefineDynamicModule("HelloModule");
			// Utworzenie TypeBuilder
			TypeBuilder typeBuilder = moduleBuilder.DefineType("HelloClass", TypeAttributes.Public);
			// Utworzenie MethodBuilder
			MethodBuilder methodBuilder = typeBuilder.DefineMethod("HelloWorld", MethodAttributes.Public, null, null);
			PermissionSet ps = new PermissionSet(PermissionState.Unrestricted);
			EnvironmentPermission cp = new EnvironmentPermission(PermissionState.Unrestricted);
			ps.AddPermission(cp);
			methodBuilder.AddDeclarativeSecurity(SecurityAction.LinkDemand, ps);
			// Utworzenie generatora MSIL
			ILGenerator msil = methodBuilder.GetILGenerator();
			// Wygenerowanie kodu
			msil.EmitWriteLine("Witaj wiecie!");
			msil.Emit(OpCodes.Ret);
			// Zwrcenie utworzonego typu
			return typeBuilder.CreateType();
		}
		void TestThread()
		{
			try
			{
				while(true)
				{ 
					Type t = GenerateCode();
					object o = Activator.CreateInstance(t);
					MethodInfo mi = t.GetMethod("HelloWorld");
					mi.Invoke(o, null);
					Thread.Sleep(500);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
		}
		static void Main(string [] args)
		{
			JitMain m = new JitMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}